<?php
// Database Connection
session_start();
include "Admin/config.php";

// Fetch active sliders from the database
$pro_slider = $conn->query("SELECT * FROM slider WHERE status = 1");
$testimonial_result = $conn->query("SELECT * FROM testimonials WHERE status = 1");

?>

<!DOCTYPE html>
<html lang="en">


<head>

    <meta charset="utf-8">
    <title>Creative Moments Studio</title>
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="keywords" content="">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link
        href="https://fonts.googleapis.com/css?family=Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Adamina" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Libre+Baskerville:400,400i,700&amp;display=swap"
        rel="stylesheet">


    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/jquery-ui.css">

    <link rel="stylesheet" href="assets/css/font-awesome.min.css">

    <link rel="stylesheet" href="assets/css/flaticon/flaticon.css">

    <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
    <link rel="stylesheet" href="assets/css/owl.theme.default.min.css">

    <link rel="stylesheet" href="assets/css/jquery.fancybox.min.css">

    <link rel="stylesheet" href="assets/css/slicknav.min.css">
    <link rel="stylesheet" href="assets/css/nav-menu.css">

    <link rel="stylesheet" href="assets/css/vmm.menu.css">

    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/css/ripple.min.css">

    <link rel="stylesheet" href="assets/css/style.css">

    <link rel="shortcut icon" type="image/png" href="assets/img/favicon.png">


    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
</head>

<body onload="DrawCaptcha();">
    <div id="preloader"><img src="./assets/img/favicon.png" alt=""></div>

    <?php include "header.php"; ?>



<section class="hero-area hero_V5">
    <div class="heroV5-carousel owl-carousel owl-theme">
        <?php
        if ($pro_slider->num_rows > 0) {
            while ($slider_row = mysqli_fetch_array($pro_slider)) {
        ?>
                <div class="item">
                    <div class="single-hero5">
                        <img src="assets/images/banner/<?php echo $slider_row["image"]; ?>" alt="" class="sh5bg wow zoomIn" data-wow-delay=".45s">
                        <div class="hero-text">
                        <h2 class="wow fadeInUp" data-wow-delay=".95s"><?php echo htmlspecialchars($slider_row["name"]); ?></h2>
                        </div>
                        <div class="hb-bottom">
                            <div class="hb-social">
                                <ul>
                                    <li class="wow fadeInUp" data-wow-delay=".15s"><a href="#"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
                                    <li class="wow fadeInUp" data-wow-delay=".15s"><a href="https://www.facebook.com/profile.php?id=100071598484188&mibextid=LQQJ4d">
                                            <i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                                    <li class="wow fadeInUp" data-wow-delay=".15s"><a href="#"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
                                </ul>
                            </div>
                            <div class="hb-phone">
                                <p class="wow fadeInUp" data-wow-delay=".15s"><i class="fa fa-phone" aria-hidden="true"></i> 
                                    <a href="tel:9710081912" style="color: white;">9710081912</a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
        <?php
            }
        } else { 
            // Default/fallback hero slider
        ?>
            <div class="item">
                <div class="single-hero5">
                    <img src="assets/img/bg/hero-8.jpg" alt="" class="sh5bg">
                    <div class="hero-text">
                        <h2>Ideal Wedding Photographer</h2>
                    </div>
                    <div class="hb-bottom">
                        <div class="hb-social">
                            <ul>
                                <li><a href="#"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
                                <li><a href="https://www.facebook.com/profile.php?id=100071598484188&mibextid=LQQJ4d">
                                        <i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                                <li><a href="#"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
                            </ul>
                        </div>
                        <div class="hb-phone">
                            <p><i class="fa fa-phone" aria-hidden="true"></i> 
                                <a href="tel:9710081912" style="color: white;">9710081912</a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</section>


    <!--About section-->
    <section id="about" class="about-area about-1 section-padding about-spa">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="about-img about3-img">
                        <img src="assets/img/section-img/about-3-2.jpg" alt="" class="a3img-1 wow fadeInLeft"
                            data-wow-delay=".35s">
                        <img src="assets/img/section-img/about-3.png" alt="" class="a3img-2 wow fadeInLeft"
                            data-wow-delay=".65s">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="about-text about3-text">
                        <h3 class="wow fadeInUp white-col" data-wow-delay=".25s">Every Viewer Is Going To Get A
                            Different Thing. That's The Thing
                            About Photography!
                        </h3>
                        <p class="wow fadeInUp" data-wow-delay=".55s">Creative moment studio has captured hundreds of weddings all over Tamilnadu. Our philosophy is simple, we treat your wedding day like it’s our own. From the very first discussions to the engagement shoot to your big day, every moment is carefully thought out and creatively architected by our team to not only capture moments but to help create them. We take care of everything we can on your special day to make sure you don’t have to worry because the only thing you should be doing on your wedding day is enjoying it with the ones you love. </p>
                        <a href="about.php" class="btn-style-1 wow fadeInUp" data-wow-delay=".85s">Read More</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--What We Do Section-->
    <section class="exclusive-service-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-titleV1  ">
                        <p class="wow fadeInUp white-col" data-wow-delay=".15s">What We Do</p>
                        <h3 class="wow fadeInUp white-col" data-wow-delay=".35s">OUR SERVICES</h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="single-service-thumbnail-V1">
                        <div class="sstv-img">
                            <img src="assets/img/service/spi-1.jpg" alt="">
                        </div>
                        <div class="sstv-text">
                            <h4>Traditional Photography</h4>
                            <p>Traditional wedding photography is still set up much like it would have been in ancient times. In this way, each shoot becomes distinctive and bespoke, offering clients the chance to express themselves in an unstaged, natural way.</p>
                            <a href="traditional-photo.php">View More<i class="fa fa-long-arrow-right"
                                    aria-hidden="true"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="single-service-thumbnail-V1">
                        <div class="sstv-img">
                            <img src="assets/img/service/spi-2.jpg" alt="">
                        </div>
                        <div class="sstv-text">
                            <h4>Traditional Videography</h4>
                            <p>Traditional Videography is best summed up as a longer, more “as it happens” style of wedding video. It is usually very comprehensive in nature. It is usually a bulky video master camcorder-like camera in a static position, with continuous recording of the rituals</p>
                            <a href="traditional-vdo.php">View More<i class="fa fa-long-arrow-right"
                                    aria-hidden="true"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="single-service-thumbnail-V1">
                        <div class="sstv-img">
                            <img src="assets/img/service/spi-3.jpg" alt="">
                        </div>
                        <div class="sstv-text">
                            <h4>candid moments</h4>
                            <p>Candid photography has its own world. We don’t ask you to pose and smile instead we click you the way you are naturally. Our candid wedding photographer will capture your deepest emotions.</p>
                            <a href="candid.php">View More<i class="fa fa-long-arrow-right"
                                    aria-hidden="true"></i></a>
                        </div>
                    </div>
                </div>





            </div>
            <!-- <div class="d-flex justify-content-center mt-4">
    <a href="traditional-photo.php" class="btn-style-1 wow fadeInUp " data-wow-delay=".85s">View All</a>
</div> -->

        </div>
    </section>



    <!--Our videos section-->
    <section class="gallery-area bgDark">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-titleV1">

                        <h3 class="wow fadeInUp white-col" data-wow-delay=".35s">Candid Moments</h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="gallery-carousel owl-carousel owl-theme wow fadeInUp" data-wow-delay=".35s">
                    <div class="item">
                        <div class="gc-single">
                            <img src="assets/img/slider/gallery/gc-img-1.jpg" alt="">
                        </div>
                    </div>
                    <div class="item">
                        <div class="gc-single">
                            <img src="assets/img/slider/gallery/gc-img-2.jpg" alt="">
                        </div>
                    </div>
                    <div class="item">
                        <div class="gc-single">
                            <img src="assets/img/slider/gallery/gc-img-3.jpg" alt="">
                        </div>
                    </div>
                    <div class="item">
                        <div class="gc-single">
                            <img src="assets/img/slider/gallery/gc-img-2.jpg" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--Our videos section-->
    <section class="gallery-area bgDark">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-titleV1">

                        <h3 class="wow fadeInUp white-col" data-wow-delay=".35s">Pre - Wedding</h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="gallery-carousel owl-carousel owl-theme wow fadeInUp" data-wow-delay=".35s">
                    <div class="item">
                        <div class="gc-single">
                            <img src="assets/img/slider/gallery/gc-img-1.jpg" alt="">
                        </div>
                    </div>
                    <div class="item">
                        <div class="gc-single">
                            <img src="assets/img/slider/gallery/gc-img-2.jpg" alt="">
                        </div>
                    </div>
                    <div class="item">
                        <div class="gc-single">
                            <img src="assets/img/slider/gallery/gc-img-3.jpg" alt="">
                        </div>
                    </div>
                    <div class="item">
                        <div class="gc-single">
                            <img src="assets/img/slider/gallery/gc-img-2.jpg" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!--Our videos section-->
    <section class="gallery-area bgDark">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-titleV1">
                        <p class="wow fadeInUp white-col" data-wow-delay=".15s">Our Videos</p>
                        <h3 class="wow fadeInUp white-col" data-wow-delay=".35s">Wedding Films</h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="gallery-carousel owl-carousel owl-theme wow fadeInUp" data-wow-delay=".35s">
                    <div class="item">
                        <div class="gc-single  lightboxContainer">
                            <img src="assets/img/slider/gallery/gc-img-1.jpg" alt="" class="lightbox">
                        </div>
                    </div>
                    <div class="item">
                        <div class="gc-single lightboxContainer">
                            <img src="assets/img/slider/gallery/gc-img-2.jpg" alt="" class="lightbox">
                        </div>
                    </div>
                    <div class="item">
                        <div class="gc-single lightboxContainer">
                            <img src="assets/img/slider/gallery/gc-img-3.jpg" alt="" class="lightbox">
                        </div>
                    </div>
                    <div class="item">
                        <div class="gc-single lightboxContainer">
                            <img src="assets/img/slider/gallery/gc-img-2.jpg" alt="" class="lightbox">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



    <!--Testimonials section-->

<?php if ($testimonial_result->num_rows > 0) { ?>
    <section class="testimonial-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-titleV1">
                        <p class="wow fadeInUp" data-wow-delay=".15s">Testimonials</p>
                        <h3 class="wow fadeInUp" data-wow-delay=".25s">QUOTES FROM OUR CLIENTS</h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="testimonial-wrapper">
                        <div id="sync1" class="testimonial-carouselV1 owl-carousel owl-theme wow fadeInUp" data-wow-delay=".45s">
                            <?php while ($testimonial = mysqli_fetch_array($testimonial_result)) { ?>
                                <div class="item">
                                    <div class="chrisSingle-testimonial">
                                        <div class="tc-text">
                                            <p><?php echo html_entity_decode($testimonial["content"]); ?></p>
                                        </div>
                                        <div class="tc-name">
                                            <h4><?php echo htmlspecialchars($testimonial["name"]); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>

                        <div id="sync2" class="tc-avatar-carousel owl-carousel owl-theme wow fadeInUp" data-wow-delay=".65s">
                            <?php
                            // Reset the result pointer and fetch testimonials again for avatars
                            $testimonial_result->data_seek(0);
                            while ($testimonial = mysqli_fetch_array($testimonial_result)) { ?>
                                <div class="item">
                                    <div class="tc-avatar">
                                        <img src="assets/images/testimonials/<?php echo htmlspecialchars($testimonial["image"]); ?>" alt="<?php echo htmlspecialchars($testimonial["name"]); ?>">
                                    </div>
                                </div>
                            <?php } ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } else { ?>
    <p class="text-center">No testimonials available.</p>
<?php } ?>


    <!--CTA Section-->
    <?php include "cta.php"; ?>

    <?php include "insta-feed.php"; ?>


    <?php include "footer.php"; ?>


    <script>
        $(document).ready(function() {
            $('.carousel').slick({
                slidesToShow: 3,
                dots: true,
                centerMode: true,
            });
        });
    </script>





    <script src="assets/js/jquery-3.2.0.min.js"></script>
    <script src="assets/js/jquery-ui.js"></script>

    <script src="assets/js/owl.carousel.min.js"></script>

    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/countdown.js"></script>
    <script src="assets/js/jquery.scrollUp.js"></script>
    <script src="assets/js/jquery.waypoints.min.js"></script>
    <script src="assets/js/shuffle.min.js"></script>
    <script src="assets/js/jquery.fancybox.min.js"></script>
    <script src="assets/js/jquery.ripples.min.js"></script>

    <script src="assets/js/jquery.slicknav.min.js"></script>

    <script src="assets/js/vmm.menu.js"></script>

    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/wow.js"></script>

    <script src="assets/js/theme.js"></script>
</body>


</html>