$(document).ready(function () {

  var engine, remoteHost, template, empty;



  $.support.cors = true;



  template = Handlebars.compile($(".result-template").html());

  empty = Handlebars.compile($(".empty-template").html());



  engine = new Bloodhound({

    identify: function (o) { return o.id_str; },

    queryTokenizer: Bloodhound.tokenizers.whitespace,

    datumTokenizer: Bloodhound.tokenizers.obj.whitespace('name', 'screen_name'),

    dupDetector: function (a, b) { return a.id_str === b.id_str; },

    remote: {

      url: remoteHost + '/demo/search?q=%QUERY',

      wildcard: '%QUERY'

    }

  });



  // ensure default users are read on initialization

  engine.get('1090217586', '58502284', '10273252', '24477185')



  function engineWithDefaults(q, sync, async) {

    if (q === '') {

      sync(engine.get('1090217586', '58502284', '10273252', '24477185'));

      async([]);

    }



    else {

      engine.search(q, sync, async);

    }

  }



  $('.demo-input').typeahead({

    hint: $('.Typeahead-hint'),

    menu: $('.Typeahead-menu'),

    minLength: 0,

    classNames: {

      open: 'is-open',

      empty: 'is-empty',

      cursor: 'is-active',

      suggestion: 'Typeahead-suggestion',

      selectable: 'Typeahead-selectable'

    }

  }, {

    source: engineWithDefaults,

    displayKey: 'screen_name',

    templates: {

      suggestion: template,

      empty: empty

    }

  })

    .on('typeahead:asyncrequest', function () {

      $('.Typeahead-spinner').show();

    })

    .on('typeahead:asynccancel typeahead:asyncreceive', function () {

      $('.Typeahead-spinner').hide();

    });



});